document.addEventListener("DOMContentLoaded", function () {
  const passwordField = document.getElementById("password_1");
  if (passwordField) {
    const requirementsHtml = `
          <div id="password-requirements" style="color: red; margin-top: 10px;">
              <p id="length" class="requirement">Au moins 12 caractères</p>
              <p id="uppercase" class="requirement">Au moins une lettre majuscule</p>
              <p id="lowercase" class="requirement">Au moins une lettre minuscule</p>
              <p id="digit" class="requirement">Au moins un chiffre</p>
              <p id="special" class="requirement">Au moins un caractère spécial</p>
          </div>
      `;
    passwordField.insertAdjacentHTML("afterend", requirementsHtml);
    const form = passwordField.closest("form");
    const submitButton = form.querySelector('button[type="submit"]'); 
    submitButton.disabled = true; 

    passwordField.addEventListener("input", function () {
      const value = passwordField.value;
      const lengthReq = value.length >= 12;
      const upperReq = /[A-Z]/.test(value);
      const lowerReq = /[a-z]/.test(value);
      const digitReq = /[0-9]/.test(value);
      const specialReq = /[^a-zA-Z0-9]/.test(value);

      document.getElementById("length").style.display = lengthReq
        ? "none"
        : "block";
      document.getElementById("uppercase").style.display = upperReq
        ? "none"
        : "block";
      document.getElementById("lowercase").style.display = lowerReq
        ? "none"
        : "block";
      document.getElementById("digit").style.display = digitReq
        ? "none"
        : "block";
      document.getElementById("special").style.display = specialReq
        ? "none"
        : "block";

      submitButton.disabled = !(
        lengthReq &&
        upperReq &&
        lowerReq &&
        digitReq &&
        specialReq
      ); 
    });
  }
});
