<?php
add_action('woocommerce_created_customer', 'save_acceptations');
function save_acceptations($customer_id)
{
    if (isset($_POST['accept_cgv'])) {
        update_user_meta($customer_id, 'accept_cgv', 'yes');
    }
    if (isset($_POST['accept_cgu'])) {
        update_user_meta($customer_id, 'accept_cgu', 'yes');
    }
    if (isset($_POST['accept_confidentialite'])) {
        update_user_meta($customer_id, 'accept_confidentialite', 'yes');
    }
}
add_action('woocommerce_register_form', 'add_coordonate_fields');
function add_coordonate_fields()
{
?>
    <div class="registration-form__coordinates">
        <p class="registration-form__field">
            <label for="reg_shipping_first_name" class="registration-form__label"><?php _e('Prénom', 'woocommerce'); ?><span class="required">*</span></label>
            <input type="text" class="registration-form__input" name="shipping_first_name" id="reg_shipping_first_name" required />
        </p>
        <p class="registration-form__field">
            <label for="reg_shipping_last_name" class="registration-form__label"><?php _e('Nom', 'woocommerce'); ?><span class="required">*</span></label>
            <input type="text" class="registration-form__input" name="shipping_last_name" id="reg_shipping_last_name" required />
        </p>
        <p class="registration-form__field">
            <label for="reg_shipping_address_1" class="registration-form__label"><?php _e('Numéro et nom de rue', 'woocommerce'); ?><span class="required">*</span></label>
            <input type="text" class="registration-form__input" name="shipping_address_1" id="reg_shipping_address_1" required />
        </p>
        <p class="registration-form__field">
            <label for="reg_shipping_address_2" class="registration-form__label"><?php _e('Appartement, suite, unité, etc. (facultatif)', 'woocommerce'); ?></label>
            <input type="text" class="registration-form__input" name="shipping_address_2" id="reg_shipping_address_2" />
        </p>
        <p class="registration-form__field">
            <label for="reg_shipping_city" class="registration-form__label"><?php _e('Ville', 'woocommerce'); ?><span class="required">*</span></label>
            <select name="shipping_city" id="reg_shipping_city" class="registration-form__input" required>
                <option value="">Sélectionnez une ville</option>
                <?php 
                $jsonDoc = file_get_contents("/home/ftgevcr/bugey/wp-content/themes/divi-child/city.json", "city.json");
                $dataCities = json_decode($jsonDoc, true);
                foreach ($dataCities["cities"] as $city) { ?>
                    <option value="<?php echo htmlspecialchars($city["name"]); ?>">
                        <?php echo htmlspecialchars($city["name"]); ?>
                    </option>
                <?php } ?>
            </select>
        </p>
    <div class="registration-form__coordinates">
        <p class="registration-form__field">

            <label for="reg_shipping_postcode" class="registration-form__label"><?php _e('Code postal', 'woocommerce'); ?><span class="required">*</span></label>

            <input type="text" class="registration-form__input" name="shipping_postcode" id="reg_shipping_postcode" required disabled/>

        </p>

        <p class="registration-form__field">

            <label for="reg_shipping_phone" class="registration-form__label"><?php _e('Téléphone', 'woocommerce'); ?><span class="required">*</span></label>

            <input type="tel" class="registration-form__input" name="shipping_phone" id="reg_shipping_phone" required />

        </p>

    </div>

<?php

}

add_action('woocommerce_register_post', 'validate_coordonate_fields', 10, 3);

function validate_coordonate_fields($username, $email, $validation_errors)

{

    if (empty($_POST['shipping_first_name'])) {

        $validation_errors->add('shipping_first_name_error', __('Le prénom est obligatoire.', 'woocommerce'));

    }

    if (empty($_POST['shipping_last_name'])) {

        $validation_errors->add('shipping_last_name_error', __('Le nom est obligatoire.', 'woocommerce'));

    }

    if (empty($_POST['shipping_address_1'])) {

        $validation_errors->add('shipping_address_1_error', __('L\'adresse est obligatoire.', 'woocommerce'));

    }

    if (empty($_POST['shipping_city']) || $_POST['shipping_city'] == '') {

        $validation_errors->add('shipping_city_error', __('Le choix de la ville est obligatoire.', 'woocommerce'));

    }

    if (empty($_POST['shipping_postcode'])) {

        $validation_errors->add('shipping_postcode_error', __('Le code postal est obligatoire.', 'woocommerce'));

    }

    if (empty($_POST['shipping_phone'])) {

        $validation_errors->add('shipping_phone_error', __('Le numéro de téléphone est obligatoire.', 'woocommerce'));

    }



    return $validation_errors;

}



add_action('woocommerce_created_customer', 'save_coordonate_fields');

function save_coordonate_fields($customer_id)

{

    if (isset($_POST['shipping_first_name'])) {

        update_user_meta($customer_id, 'shipping_first_name', sanitize_text_field($_POST['shipping_first_name']));

        update_user_meta($customer_id, 'billing_first_name', sanitize_text_field($_POST['shipping_first_name'])); // Optionnel

    }

    if (isset($_POST['shipping_last_name'])) {

        update_user_meta($customer_id, 'shipping_last_name', sanitize_text_field($_POST['shipping_last_name']));

        update_user_meta($customer_id, 'billing_last_name', sanitize_text_field($_POST['shipping_last_name'])); // Optionnel

    }

    if (isset($_POST['shipping_address_1'])) {

        update_user_meta($customer_id, 'shipping_address_1', sanitize_text_field($_POST['shipping_address_1']));

        update_user_meta($customer_id, 'billing_address_1', sanitize_text_field($_POST['shipping_address_1'])); // Optionnel

    }

    if (isset($_POST['shipping_address_2'])) {

        update_user_meta($customer_id, 'shipping_address_2', sanitize_text_field($_POST['shipping_address_2']));

        update_user_meta($customer_id, 'billing_address_2', sanitize_text_field($_POST['shipping_address_2'])); // Optionnel

    }

    if (isset($_POST['shipping_city'])) {

        update_user_meta($customer_id, 'shipping_city', sanitize_text_field($_POST['shipping_city']));

        update_user_meta($customer_id, 'billing_city', sanitize_text_field($_POST['shipping_city'])); // Optionnel

    }

    if (isset($_POST['shipping_postcode'])) {

        update_user_meta($customer_id, 'shipping_postcode', sanitize_text_field($_POST['shipping_postcode']));

        update_user_meta($customer_id, 'billing_postcode', sanitize_text_field($_POST['shipping_postcode'])); // Optionnel

    }

    if (isset($_POST['shipping_phone'])) {

        update_user_meta($customer_id, 'shipping_phone', sanitize_text_field($_POST['shipping_phone']));

        update_user_meta($customer_id, 'billing_phone', sanitize_text_field($_POST['shipping_phone']));

    }

}

add_action('woocommerce_register_form', 'add_conditions_fields');

function add_conditions_fields()

{

?>

    <div class="registration-form__conditions">

        <p class="registration-form__condition">

            <input type="checkbox" name="accept_cgv" id="reg_accept_cgv" class="registration-form__checkbox" required />

            <label for="reg_accept_cgv" class="registration-form__label"><?php _e('J’accepte les ', 'woocommerce'); ?><a href="https://votresite.com/cgv/" class="registration-form__link" target="_blank">Conditions Générales de Vente</a></label>

        </p>

        <p class="registration-form__condition">

            <input type="checkbox" name="accept_cgu" id="reg_accept_cgu" class="registration-form__checkbox" required />

            <label for="reg_accept_cgu" class="registration-form__label"><?php _e('J’accepte les ', 'woocommerce'); ?><a href="https://votresite.com/cgu/" class="registration-form__link" target="_blank">Conditions Générales d’Utilisation</a></label>

        </p>

        <p class="registration-form__condition">

            <input type="checkbox" name="accept_confidentialite" id="reg_accept_confidentialite" class="registration-form__checkbox" required />

            <label for="reg_accept_confidentialite" class="registration-form__label"><?php _e('J’accepte la ', 'woocommerce'); ?><a href="https://votresite.com/confidentialite/" class="registration-form__link" target="_blank">Politique de Confidentialité</a></label>

        </p>

    </div>



<?php

}

add_action('woocommerce_register_post', 'validate_conditions_inscription', 10, 3);

function validate_conditions_inscription($username, $email, $validation_errors)

{

    if (!isset($_POST['accept_cgv']) || !$_POST['accept_cgv']) {

        $validation_errors->add('accept_cgv_error', __('Vous devez accepter les Conditions Générales de Vente.', 'woocommerce'));

    }

    if (!isset($_POST['accept_cgu']) || !$_POST['accept_cgu']) {

        $validation_errors->add('accept_cgu_error', __('Vous devez accepter les Conditions Générales d’Utilisation.', 'woocommerce'));

    }

    if (!isset($_POST['accept_confidentialite']) || !$_POST['accept_confidentialite']) {

        $validation_errors->add('accept_confidentialite_error', __('Vous devez accepter la Politique de Confidentialité.', 'woocommerce'));

    }

    return $validation_errors;

}

function enqueue_custom_scripts()

{

    wp_enqueue_script('custom-password-validation', get_stylesheet_directory_uri() . '/validation.js', array('jquery'), null, true);
    wp_enqueue_script('custom-select-listener', get_stylesheet_directory_uri() . '/selectListener.js', array('jquery'), null, true);
    wp_localize_script('custom-select-listener', 'ajaxobject', array('cityJsonUrl' => get_stylesheet_directory_uri() . '/city.json'));

}

add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');

