<?php
/**
 * Class CountryFlags
 *
 * @package WooCommerce\Payments
 */

namespace WCPay\MultiCurrency;

use WCPay\Constants\Country_Code;
use WCPay\Constants\Currency_Code;

defined( 'ABSPATH' ) || exit;

/**
 * Class that bring flags per country/currency.
 */
class CountryFlags {

	const EMOJI_COUNTRIES_FLAGS = [
		Country_Code::ANDORRA                          => '🇦🇩',
		Country_Code::UNITED_ARAB_EMIRATES             => '🇦🇪',
		Country_Code::AFGHANISTAN                      => '🇦🇫',
		Country_Code::ANTIGUA_AND_BARBUDA              => '🇦🇬',
		Country_Code::ANGUILLA                         => '🇦🇮',
		Country_Code::ALBANIA                          => '🇦🇱',
		Country_Code::ARMENIA                          => '🇦🇲',
		Country_Code::ANGOLA                           => '🇦🇴',
		Country_Code::ANTARCTICA                       => '🇦🇶',
		Country_Code::ARGENTINA                        => '🇦🇷',
		Country_Code::AMERICAN_SAMOA                   => '🇦🇸',
		Country_Code::AUSTRIA                          => '🇦🇹',
		Country_Code::AUSTRALIA                        => '🇦🇺',
		Country_Code::ARUBA                            => '🇦🇼',
		Country_Code::ALAND_ISLANDS                    => '🇦🇽',
		Country_Code::AZERBAIJAN                       => '🇦🇿',
		Country_Code::BOSNIA_AND_HERZEGOVINA           => '🇧🇦',
		Country_Code::BARBADOS                         => '🇧🇧',
		Country_Code::BANGLADESH                       => '🇧🇩',
		Country_Code::BELGIUM                          => '🇧🇪',
		Country_Code::BURKINA_FASO                     => '🇧🇫',
		Country_Code::BULGARIA                         => '🇧🇬',
		Country_Code::BAHRAIN                          => '🇧🇭',
		Country_Code::BURUNDI                          => '🇧🇮',
		Country_Code::BENIN                            => '🇧🇯',
		Country_Code::SAINT_BARTHELEMY                 => '🇧🇱',
		Country_Code::BERMUDA                          => '🇧🇲',
		Country_Code::BRUNEI                           => '🇧🇳',
		Country_Code::BOLIVIA                          => '🇧🇴',
		Country_Code::CARIBBEAN_NETHERLANDS            => '🇧🇶',
		Country_Code::BRAZIL                           => '🇧🇷',
		Country_Code::BAHAMAS                          => '🇧🇸',
		Country_Code::BHUTAN                           => '🇧🇹',
		Country_Code::BOUVET_ISLAND                    => '🇧🇻',
		Country_Code::BOTSWANA                         => '🇧🇼',
		Country_Code::BELARUS                          => '🇧🇾',
		Country_Code::BELIZE                           => '🇧🇿',
		Country_Code::CANADA                           => '🇨🇦',
		Country_Code::COCOS_KEELING_ISLANDS            => '🇨🇨',
		Country_Code::DEMOCRATIC_REPUBLIC_OF_THE_CONGO => '🇨🇩',
		Country_Code::CENTRAL_AFRICAN_REPUBLIC         => '🇨🇫',
		Country_Code::CONGO                            => '🇨🇬',
		Country_Code::SWITZERLAND                      => '🇨🇭',
		Country_Code::IVORY_COAST                      => '🇨🇮',
		Country_Code::COOK_ISLANDS                     => '🇨🇰',
		Country_Code::CHILE                            => '🇨🇱',
		Country_Code::CAMEROON                         => '🇨🇲',
		Country_Code::CHINA                            => '🇨🇳',
		Country_Code::COLOMBIA                         => '🇨🇴',
		Country_Code::COSTA_RICA                       => '🇨🇷',
		Country_Code::CUBA                             => '🇨🇺',
		Country_Code::CABO_VERDE                       => '🇨🇻',
		'CW'                                           => '🇨🇼',
		'CX'                                           => '🇨🇽',
		Country_Code::CYPRUS                           => '🇨🇾',
		Country_Code::CZECHIA                          => '🇨🇿',
		Country_Code::GERMANY                          => '🇩🇪',
		Country_Code::DJIBOUTI                         => '🇩🇯',
		Country_Code::DENMARK                          => '🇩🇰',
		Country_Code::DOMINICA                         => '🇩🇲',
		Country_Code::DOMINICAN_REPUBLIC               => '🇩🇴',
		Country_Code::ALGERIA                          => '🇩🇿',
		Country_Code::ECUADOR                          => '🇪🇨',
		Country_Code::ESTONIA                          => '🇪🇪',
		Country_Code::EGYPT                            => '🇪🇬',
		'EH'                                           => '🇪🇭',
		Country_Code::ERITREA                          => '🇪🇷',
		Country_Code::SPAIN                            => '🇪🇸',
		Country_Code::ETHIOPIA                         => '🇪🇹',
		'EU'                                           => '🇪🇺',
		Country_Code::FINLAND                          => '🇫🇮',
		Country_Code::FIJI                             => '🇫🇯',
		'FK'                                           => '🇫🇰',
		Country_Code::MICRONESIA                       => '🇫🇲',
		'FO'                                           => '🇫🇴',
		Country_Code::FRANCE                           => '🇫🇷',
		Country_Code::GABON                            => '🇬🇦',
		Country_Code::UNITED_KINGDOM                   => '🇬🇧',
		Country_Code::GRENADA                          => '🇬🇩',
		Country_Code::GEORGIA                          => '🇬🇪',
		'GF'                                           => '🇬🇫',
		'GG'                                           => '🇬🇬',
		Country_Code::GHANA                            => '🇬🇭',
		Country_Code::GIBRALTAR                        => '🇬🇮',
		'GL'                                           => '🇬🇱',
		Country_Code::GAMBIA                           => '🇬🇲',
		Country_Code::GUINEA                           => '🇬🇳',
		'GP'                                           => '🇬🇵',
		Country_Code::EQUATORIAL_GUINEA                => '🇬🇶',
		Country_Code::GREECE                           => '🇬🇷',
		'GS'                                           => '🇬🇸',
		Country_Code::GUATEMALA                        => '🇬🇹',
		'GU'                                           => '🇬🇺',
		Country_Code::GUINEA_BISSAU                    => '🇬🇼',
		Country_Code::GUYANA                           => '🇬🇾',
		Country_Code::HONG_KONG                        => '🇭🇰',
		'HM'                                           => '🇭🇲',
		Country_Code::HONDURAS                         => '🇭🇳',
		Country_Code::CROATIA                          => '🇭🇷',
		Country_Code::HAITI                            => '🇭🇹',
		Country_Code::HUNGARY                          => '🇭🇺',
		Country_Code::INDONESIA                        => '🇮🇩',
		Country_Code::IRELAND                          => '🇮🇪',
		Country_Code::ISRAEL                           => '🇮🇱',
		'IM'                                           => '🇮🇲',
		Country_Code::INDIA                            => '🇮🇳',
		Country_Code::BRITISH_INDIAN_OCEAN_TERRITORY   => '🇮🇴',
		Country_Code::IRAQ                             => '🇮🇶',
		Country_Code::IRAN                             => '🇮🇷',
		Country_Code::ICELAND                          => '🇮🇸',
		Country_Code::ITALY                            => '🇮🇹',
		'JE'                                           => '🇯🇪',
		Country_Code::JAMAICA                          => '🇯🇲',
		Country_Code::JORDAN                           => '🇯🇴',
		Country_Code::JAPAN                            => '🇯🇵',
		Country_Code::KENYA                            => '🇰🇪',
		Country_Code::KYRGYZSTAN                       => '🇰🇬',
		Country_Code::CAMBODIA                         => '🇰🇭',
		Country_Code::KIRIBATI                         => '🇰🇮',
		Country_Code::COMOROS                          => '🇰🇲',
		Country_Code::SAINT_KITTS_AND_NEVIS            => '🇰🇳',
		Country_Code::NORTH_KOREA                      => '🇰🇵',
		Country_Code::SOUTH_KOREA                      => '🇰🇷',
		Country_Code::KUWAIT                           => '🇰🇼',
		'KY'                                           => '🇰🇾',
		Country_Code::KAZAKHSTAN                       => '🇰🇿',
		Country_Code::LAOS                             => '🇱🇦',
		Country_Code::LEBANON                          => '🇱🇧',
		Country_Code::SAINT_LUCIA                      => '🇱🇨',
		Country_Code::LIECHTENSTEIN                    => '🇱🇮',
		Country_Code::SRI_LANKA                        => '🇱🇰',
		Country_Code::LIBERIA                          => '🇱🇷',
		Country_Code::LESOTHO                          => '🇱🇸',
		Country_Code::LITHUANIA                        => '🇱🇹',
		Country_Code::LUXEMBOURG                       => '🇱🇺',
		Country_Code::LATVIA                           => '🇱🇻',
		Country_Code::LIBYA                            => '🇱🇾',
		Country_Code::MOROCCO                          => '🇲🇦',
		Country_Code::MONACO                           => '🇲🇨',
		Country_Code::MOLDOVA                          => '🇲🇩',
		Country_Code::MONTENEGRO                       => '🇲🇪',
		'MF'                                           => '🇲🇫',
		Country_Code::MADAGASCAR                       => '🇲🇬',
		Country_Code::MARSHALL_ISLANDS                 => '🇲🇭',
		Country_Code::NORTH_MACEDONIA                  => '🇲🇰',
		Country_Code::MALI                             => '🇲🇱',
		Country_Code::MYANMAR                          => '🇲🇲',
		Country_Code::MONGOLIA                         => '🇲🇳',
		'MO'                                           => '🇲🇴',
		'MP'                                           => '🇲🇵',
		'MQ'                                           => '🇲🇶',
		Country_Code::MAURITANIA                       => '🇲🇷',
		'MS'                                           => '🇲🇸',
		Country_Code::MALTA                            => '🇲🇹',
		Country_Code::MAURITIUS                        => '🇲🇺',
		Country_Code::MALDIVES                         => '🇲🇻',
		Country_Code::MALAWI                           => '🇲🇼',
		Country_Code::MEXICO                           => '🇲🇽',
		Country_Code::MALAYSIA                         => '🇲🇾',
		Country_Code::MOZAMBIQUE                       => '🇲🇿',
		Country_Code::NAMIBIA                          => '🇳🇦',
		'NC'                                           => '🇳🇨',
		Country_Code::NIGER                            => '🇳🇪',
		'NF'                                           => '🇳🇫',
		Country_Code::NIGERIA                          => '🇳🇬',
		Country_Code::NICARAGUA                        => '🇳🇮',
		Country_Code::NETHERLANDS                      => '🇳🇱',
		Country_Code::NORWAY                           => '🇳🇴',
		Country_Code::NEPAL                            => '🇳🇵',
		Country_Code::NAURU                            => '🇳🇷',
		'NU'                                           => '🇳🇺',
		Country_Code::NEW_ZEALAND                      => '🇳🇿',
		Country_Code::OMAN                             => '🇴🇲',
		Country_Code::PANAMA                           => '🇵🇦',
		Country_Code::PERU                             => '🇵🇪',
		'PF'                                           => '🇵🇫',
		Country_Code::PAPUA_NEW_GUINEA                 => '🇵🇬',
		Country_Code::PHILIPPINES                      => '🇵🇭',
		Country_Code::PAKISTAN                         => '🇵🇰',
		Country_Code::POLAND                           => '🇵🇱',
		'PM'                                           => '🇵🇲',
		'PN'                                           => '🇵🇳',
		'PR'                                           => '🇵🇷',
		Country_Code::PALESTINE                        => '🇵🇸',
		Country_Code::PORTUGAL                         => '🇵🇹',
		Country_Code::PALAU                            => '🇵🇼',
		Country_Code::PARAGUAY                         => '🇵🇾',
		Country_Code::QATAR                            => '🇶🇦',
		'RE'                                           => '🇷🇪',
		Country_Code::ROMANIA                          => '🇷🇴',
		Country_Code::SERBIA                           => '🇷🇸',
		Country_Code::RUSSIA                           => '🇷🇺',
		Country_Code::RWANDA                           => '🇷🇼',
		Country_Code::SAUDI_ARABIA                     => '🇸🇦',
		Country_Code::SOLOMON_ISLANDS                  => '🇸🇧',
		Country_Code::SEYCHELLES                       => '🇸🇨',
		Country_Code::SUDAN                            => '🇸🇩',
		Country_Code::SWEDEN                           => '🇸🇪',
		Country_Code::SINGAPORE                        => '🇸🇬',
		'SH'                                           => '🇸🇭',
		Country_Code::SLOVENIA                         => '🇸🇮',
		'SJ'                                           => '🇸🇯',
		Country_Code::SLOVAKIA                         => '🇸🇰',
		Country_Code::SIERRA_LEONE                     => '🇸🇱',
		Country_Code::SAN_MARINO                       => '🇸🇲',
		Country_Code::SENEGAL                          => '🇸🇳',
		Country_Code::SOMALIA                          => '🇸🇴',
		Country_Code::SURINAME                         => '🇸🇷',
		Country_Code::SOUTH_SUDAN                      => '🇸🇸',
		Country_Code::SAO_TOME_AND_PRINCIPE            => '🇸🇹',
		Country_Code::EL_SALVADOR                      => '🇸🇻',
		'SX'                                           => '🇸🇽',
		Country_Code::SYRIA                            => '🇸🇾',
		Country_Code::ESWATINI                         => '🇸🇿',
		'TC'                                           => '🇹🇨',
		Country_Code::CHAD                             => '🇹🇩',
		'TF'                                           => '🇹🇫',
		Country_Code::TOGO                             => '🇹🇬',
		Country_Code::THAILAND                         => '🇹🇭',
		Country_Code::TAJIKISTAN                       => '🇹🇯',
		'TK'                                           => '🇹🇰',
		Country_Code::EAST_TIMOR                       => '🇹🇱',
		Country_Code::TURKMENISTAN                     => '🇹🇲',
		Country_Code::TUNISIA                          => '🇹🇳',
		Country_Code::TONGA                            => '🇹🇴',
		Country_Code::TURKEY                           => '🇹🇷',
		Country_Code::TRINIDAD_AND_TOBAGO              => '🇹🇹',
		Country_Code::TUVALU                           => '🇹🇻',
		Country_Code::TAIWAN                           => '🇹🇼',
		Country_Code::TANZANIA                         => '🇹🇿',
		Country_Code::UKRAINE                          => '🇺🇦',
		Country_Code::UGANDA                           => '🇺🇬',
		'UM'                                           => '🇺🇲',
		Country_Code::UNITED_STATES                    => '🇺🇸',
		Country_Code::URUGUAY                          => '🇺🇾',
		Country_Code::UZBEKISTAN                       => '🇺🇿',
		Country_Code::VATICAN_CITY                     => '🇻🇦',
		Country_Code::SAINT_VINCENT_AND_THE_GRENADINES => '🇻🇨',
		Country_Code::VENEZUELA                        => '🇻🇪',
		'VG'                                           => '🇻🇬',
		'VI'                                           => '🇻🇮',
		Country_Code::VIETNAM                          => '🇻🇳',
		Country_Code::VANUATU                          => '🇻🇺',
		'WF'                                           => '🇼🇫',
		Country_Code::SAMOA                            => '🇼🇸',
		Country_Code::KOSOVO                           => '🇽🇰',
		Country_Code::YEMEN                            => '🇾🇪',
		'YT'                                           => '🇾🇹',
		Country_Code::SOUTH_AFRICA                     => '🇿🇦',
		Country_Code::ZAMBIA                           => '🇿🇲',
		Country_Code::ZIMBABWE                         => '🇿🇼',
	];

	/**
	 * Retrieves a flag by country code.
	 *
	 * @param string $country country alpha-2 code (ISO 3166) like US.
	 * @return string
	 */
	public static function get_by_country( string $country ): string {
		return self::EMOJI_COUNTRIES_FLAGS[ $country ] ?? '';
	}

	/**
	 * Retrieves a flag by currency code.
	 *
	 * @param string $currency currency code (ISO 4217) like USD.
	 * @return string
	 */
	public static function get_by_currency( string $currency ): string {
		$exceptions = [
			Currency_Code::NETHERLANDS_ANTILLEAN_GUILDER => '',
			Currency_Code::BITCOIN                       => '',
			Currency_Code::CENTRAL_AFRICAN_CFA_FRANC     => '',
			Currency_Code::EAST_CARIBBEAN_DOLLAR         => '',
			Currency_Code::WEST_AFRICAN_CFA_FRANC        => '',
			Currency_Code::CFP_FRANC                     => '',
		];

		$flag = $exceptions[ $currency ] ?? self::get_by_country( substr( $currency, 0, -1 ) );

		return $flag;
	}
}
